<?
use Bitrix\Main\Loader;

class BreadCrumbsClass extends CBitrixComponent{
	public function img($img){
		if((int)$img>0 && CFile::GetPath($img)!=''){
			return CFile::GetPath($img);
		}
		return $GLOBALS['code_arr']['demophoto'];
	}
	public function arr($arr){
		echo '<pre>';
		print_r($arr);
		echo '</pre>';
	}
	public function parentSections($result,$section_id){		
		Loader::includeModule('iblock');
		$codes='';
		$list = CIBlockSection::GetNavChain(false, $section_id, ['ID', 'NAME', 'DEPTH_LEVEL','CODE'], true);
		foreach ($list as $i=>$v){	 
			if($v['ID']) {
                $codes.='/'.$v['CODE'];
                $result['/catalog'.$codes.'/'] = $v['NAME'];
			}
		}
		return $result;	
	}
	public function parentElement($arr,$id,$name){ 
		Loader::includeModule('iblock');
		$codes = ''; 	
		$res = CIBlockElement::GetElementGroups($id, true, ['NAME', 'CODE']); 
		while($ar_res = $res->Fetch())
		{
			$codes.='/'.$ar_res['CODE'];
			$arr['/catalog'.$codes.'/'] = htmlspecialchars_decode($ar_res['NAME']);
		}
		if($name!=''){
			$arr['#'] = $name;
		}
		return $arr;
	}
	public function myElement($arr,$id,$name){ 
		Loader::includeModule('iblock');
		$codes = ''; 	
		$res = CIBlockElement::GetElementGroups($id, true, ['NAME', 'CODE','PICTURE']); 
		while($ar_res = $res->Fetch())
		{
			$codes.='/'.$ar_res['CODE'];
			$arr['/catalog'.$codes.'/'] = ['name'=>htmlspecialchars_decode($ar_res['NAME']),'img'=>$this->img($ar_res['PICTURE'])];
		}
		$arr['#'] = $name;
		return $arr;
	}
	public function select($arParams){
		if(isset($arParams['IBLOCK_ID'])){	
			if(isset($arParams['SECTION'])){
				$arr = $this->parentSections($arParams['ARR'],$arParams['ID']);
			}
			else if(isset($arParams['DETAIL'])){
				$arr = $this->myElement($arParams['ARR'],$arParams['ID'],htmlspecialchars_decode($arParams['NAME']));
			}
			else{ 	
				$arr = $this->parentElement($arParams['ARR'],$arParams['ID'],htmlspecialchars_decode($arParams['NAME']));
			}			
			return $arr;	
		}
		else if(isset($arParams['ARRAY'])){
			$return = $arParams['ARRAY'];
		}
		else{
			return false;
		}
		return $return;
	}

    public function executeComponent(){
        $this->includeComponentLang('lang.php');
		$this->arResult = $this->select($this->arParams);
		if(isset($this->arParams['INSERT_LOG'])){
			$this->arr($this->arParams);
			$this->arr($this->arResult);
		}
		$this->InitComponentTemplate();
		$template = $this->GetTemplate();
		if (@$_SERVER['HTTP_X_REQUESTED_WITH'] != 'XMLHttpRequest') {
			componentCss(__DIR__,$template);
			componentJs(__DIR__,$template);
		}
        $this->IncludeComponentTemplate(); 
    }
}