<?
use Bitrix\Main\Application;
use Bitrix\Main\Loader;
use \Bitrix\Catalog;
use \Bitrix\Catalog\StoreProductTable;
use Bitrix\Main\ORM\Data\DataManager;
require_once($_SERVER['DOCUMENT_ROOT'].'/bitrix/modules/iblock/lib/sectionpropertytable.php');
class CatalogElementClass extends CBitrixComponent{
	public function img($img){
		if((int)$img>0 && CFile::GetPath($img)!=''){
			return CFile::GetPath($img);
		}
		return $GLOBALS['code_arr']['demophoto'];
	}

	public function isimg($img){
		if((int)$img>0 && CFile::GetPath($img)!=''){
			return true;
		}
		return false;
	}
	public function arr($arr){
		echo '<pre>';
		print_r($arr);
		echo '</pre>';
	}
	public function user(){
		global $USER;
		if ($USER->IsAuthorized()){
			$rsUser = CUser::GetByID($USER->GetID());
			$arUser = $rsUser->Fetch();
			$BDate = explode('.',$arUser['PERSONAL_BIRTHDAY']);
			$arUser['PERSONAL_BIRTHDAY'] = $BDate[2].'-'.$BDate[1].'-'.$BDate[0];
			return $arUser;
		}
		else{
			return false;
		}
	}	
	public function url($request){
		$uriString = $request->getRequestUri();
		return $uriString;
	}
	private function urlparam($request){
  		if(isset($request['code'])){
			$code = explode('/',$request['code'])[0];
			return $code;	 
		}
		return false;
	}
	private function store($id,$city){
		$arr=[];
		$rsStoreProduct = StoreProductTable::getList(array(
			'filter' => array('=PRODUCT_ID'=>$id,'STORE.ACTIVE'=>'Y'),
			'select' => array('AMOUNT','STORE_ID','STORE_TITLE' => 'STORE.TITLE'),
		));		
		while($arStoreProduct=$rsStoreProduct->fetch()){
			if((int)$arStoreProduct['STORE_ID']!=(int)$GLOBALS['code_arr']['shopzakaz']){
				$arStore = Catalog\StoreTable::getRow([
					'select' => ['TITLE', 'ADDRESS', 'PHONE','SCHEDULE','GPS_N','GPS_S','UF_CITYF'],
					'filter' => [
					'ID' => $arStoreProduct['STORE_ID'],
					]
				]);
				if($arStore['UF_CITYF']==$city && $arStore['TITLE']!='Под заказ'){
					if($arStoreProduct['AMOUNT']>0){
						$arStore['COUNT'] = 1;
						$arr[]=$arStore;
					}
					else{
						$arStore['COUNT'] = 0;
						$arr[]=$arStore;
					}					
				}
			}				
		}
		return $arr;
	} 
	private function section($id){
		$arFilter = array('IBLOCK_ID' => $GLOBALS['code_arr']['idCat'],'ID' => $id); 
		$rsSect = CIBlockSection::GetList(Array("SORT"=>"ASC"),$arFilter, false, array('ID', 'NAME', 'SECTION_PAGE_URL', 'PICTURE'));
		while($ar_res = $rsSect->GetNext()){
				$result = $ar_res;				
		}
		return $result;
	}
	public function sectionall($id,$name){
		$arSections = [];
		$result = ['/'=>'Главная','/catalog/'=>'Каталог'];
		while($id) {
			if ($arSection = \Bitrix\Iblock\SectionTable::getList([
				'filter' => ['IBLOCK_ID' => $GLOBALS['code_arr']['idCat'], 'ID' => $id],
				'select' => ['ID', 'IBLOCK_SECTION_ID']
			])->fetch()) {
				$arSections[] = $arSection;
			}
			$id = $arSection['IBLOCK_SECTION_ID'];
		}
		$arSections = array_reverse($arSections);
		foreach($arSections as $key=>$item){			
			$temp = $this->section($item['ID']);
			if($key==0){
				$GLOBALS['code_arr']['pictureCategory'] = $this->img($temp['PICTURE']);
				$GLOBALS['code_arr']['nameCategory'] = $temp['NAME'];
			}
			$result[$temp['SECTION_PAGE_URL']] = $temp['NAME'];
		}
		$result['#name'] = $name;
		return $result;
	}
	public function getFilterProperty($iblock,$sectionId)
	{
		$arr = [];
		$propertyList = \Bitrix\Iblock\SectionPropertyTable::getList(array("select" => array("PROPERTY_ID", "PROPERTY.PROPERTY_TYPE"), "filter" => array("=IBLOCK_ID" => array($iblock, $sectionId))));
		while ($link = $propertyList->fetch()) {
			$arr[] = $link['PROPERTY_ID'];
		}
		return $arr;
	}
	public function select($arParam,$rArr){
		$arrnoprop = [];	
		foreach($GLOBALS['code_arr']['noprop'] as $valnoprop){
			$arrnoprop[] = $valnoprop[0];
		}
		if(isset($arParam['code'])){
			$code = $arParam['code'];
		}
		else{
			$code = $this->urlparam($rArr->toArray());
		}
		CModule::IncludeModule("iblock");
		$arSelect = ['ID',"IBLOCK_ID",'NAME','XML_ID','DETAIL_PAGE_URL','IBLOCK_SECTION_ID','SECTION_ID','DETAIL_PICTURE','PROPERTY_*','PREVIEW_TEXT','DETAIL_TEXT','PREVIEW_PICTURE','CATALOG_PRICE_'.$arParam['priceold'],'CATALOG_PRICE_'.$arParam['price']];
		$arFilter = ['=CODE'=>$code,'IBLOCK_ID'=>$arParam['IBLOCK_ID']];	
		$res = CIBlockElement::GetList($sort, $arFilter,false, false,$arSelect);
		$count = CIBlockElement::GetList($sort, $arFilter,[]);
		if($count==0){
			LocalRedirect("/404.php", "404 Not Found");
		}
		while($ob = $res->GetNextElement()){ 
			$fields = $ob->GetFields();
			$arProps = $ob->GetProperties();
			if(isset($arParam['SALE'])){
				$sale = saleInit($arProps,$arParam['SALE']);
			}
			else{
				$sale = [];
			}
			$section_id = $fields['IBLOCK_SECTION_ID'];
			$get_fields = CIBlockSection::GetList(
				array(),
				array(
					'IBLOCK_ID' => $GLOBALS['code_arr']['idCat'],
					'ID' => $section_id
				),
				false,
				array(
					'UF_SHORT_CHARS_LIST'
				)
			);		
			if($get_fields_item = $get_fields->GetNext()) { 	
				$arr_prop = $get_fields_item['UF_SHORT_CHARS_LIST'];
												
			}
			$arrPropSection = $this->getFilterProperty($GLOBALS['code_arr']['idCat'],$section_id);
			foreach($arProps as $keypr=>$property){
				if($property['VALUE']!=''){
					if(!in_array($keypr,$arParam['PROP']) && in_array($keypr,$arrnoprop)===false && in_array($arProps[$keypr]['ID'],$arrPropSection)){
						if(is_array($property['VALUE'])){
							$property['VALUE'] = implode(',',$property['VALUE']);
						}
						$arProp[$property['NAME']] = $property['VALUE'];
					}
				}
			}
			foreach($arr_prop as $property){				
				if(in_array($property,$arrnoprop)===false && $arProps[$property]['VALUE']!=''){
					if(is_array($arProps[$property]['VALUE'])){
						$arProps[$property]['VALUE'] = implode(',',$arProps[$property]['VALUE']);
					}
					$arProp2[$arProps[$property]['NAME']] = $arProps[$property]['VALUE'];
				}
			}
			$photos=[];
			$isimg = true;
			if(is_array($arProps['MORE_PHOTO']['VALUE']) && count($arProps['MORE_PHOTO']['VALUE'])>0){
				foreach($arProps['MORE_PHOTO']['VALUE'] as $photo){
					$photos[] = $this->img($photo);
					$isimg = $this->isimg($photo);
				}
			}
			else{
				if((int)$fields['DETAIL_PICTURE']>0){
					$photos[] = $this->img($fields['DETAIL_PICTURE']);
					$isimg = $this->isimg($fields['DETAIL_PICTURE']);
				}
				else{
					$photos[] = $this->img($fields['PREVIEW_PICTURE']);					
					$isimg = $this->isimg($fields['PREVIEW_PICTURE']);		
				}						
			}
			$brand = $arProps['A_brenddliasayta']['VALUE'];
			$prev_text = $arProps['Akratkoetekstovoeopisanie']['VALUE'];
			$brand_arr = CIBlockElement::GetList(array("ID"=>"DESC"), ["=NAME"=>$brand,'IBLOCK_ID'=>$GLOBALS['code_arr']['idbrands']]);
			$imgbrand = '';
			while($obbrand = $brand_arr->GetNextElement()){ 
				$fbrand = $obbrand->GetFields();
				$pbrand = $obbrand->GetProperties();
				$imgbrand = $this->img($fbrand['PREVIEW_PICTURE']);
				$codebrand = $fbrand['CODE'];
				$bg = $pbrand['BACKGROUND']['VALUE'];				
			}
			if($imgbrand==''){
				$imgbrand = $GLOBALS['code_arr']['demophoto'];
			}
			$propoffer = array_merge($arParam['PROP'],$arParam['PROPS']);
			$arP = CCatalogProduct::GetByIDEx($fields['ID']);	
				
			$propArr = CCatalogSKU::getOffersList((int)$arP["PRODUCT"]['ID'],17,array(),array(),['CODE'=>$propoffer]);
			$count = $arP["PRODUCT"]['QUANTITY'];
			if((int)$arP["PRODUCT"]['WEIGHT']>0 && (int)$arP["PRODUCT"]['WIDTH']>0 && (int)$arP["PRODUCT"]['HEIGHT']>0 && (int)$arP["PRODUCT"]['LENGTH']>0){
				$param = ['weight'=>ceil($arP["PRODUCT"]['WEIGHT']/100),'length'=>ceil($arP["PRODUCT"]['LENGTH']/10),'width'=>ceil($arP["PRODUCT"]['WIDTH']/10),'height'=>ceil($arP["PRODUCT"]['HEIGHT']/10)];
			}
			else{
				$param = ['weight'=>50,'width'=>50,'height'=>50,'length'=>100];
			}
			CBitrixComponent::includeComponentClass('lemi:delivery');
			$delivery = new deliveryClass();
			$city = $delivery->city();		
			$citydef = $delivery->citydef();
			$obprods = ['ID'=>$arP["PRODUCT"]["ID"],'GUID'=>$fields['XML_ID'],'SALE'=>$sale,'PHOTO'=>$photos,'NAME'=>$fields['NAME'],'DESC'=>$fields['PREVIEW_TEXT'],'TEXT'=>$fields['DETAIL_TEXT'],'DETAIL_PAGE_URL'=>$fields['DETAIL_PAGE_URL'],'IMG'=>$this->img($fields['DETAIL_PICTURE']),'PIMG'=>$this->img($fields['PREVIEW_PICTURE']),'ISIMG'=>$isimg,'PRICE'=>ceil($fields['CATALOG_PRICE_'.$arParam['price']]),'PRICEOLD'=>ceil($fields['CATALOG_PRICE_'.$arParam['priceold']])];
			$result = ['CITY'=>$city,'PREVTEXT'=>$prev_text,'CITYDEF'=>$citydef,'PARAM'=>$param,'PRODUCT'=>$obprods,'ID'=>$fields['ID'],'COUNT'=>$count,'STORE'=>$this->store($arP["PRODUCT"]["ID"],$city),'BGBRAND'=>$bg,'CODEBRAND'=>$codebrand,'URL'=>$this->url($rArr),'PROP'=>$arProps,'PROPERTY'=>$arProp,'PROPS'=>$arProp2,'SECTION_ID'=>$fields['IBLOCK_SECTION_ID'],'SECTION'=>$this->sectionall($fields['IBLOCK_SECTION_ID'],$fields['NAME']),'BRAND'=>$brand,'IMGBRAND'=>$imgbrand];	
		}				
		return $result;
	}

    public function executeComponent(){
		global $USER;
		$_SESSION['router'] = 'product';
        $this->includeComponentLang('lang.php');
		if(isset($this->arParams['debag'])){	
			echo 'hello'.date("H:i:s");
		}
		$redis = new Redis();
		$redis->connect('127.0.0.1', 6379);
		$redis->setOption(Redis::OPT_SCAN, Redis::SCAN_RETRY);
		$key =  md5(serialize($this->arParams)).'--iblock-'.$GLOBALS['code_arr']['idCat'].'--'.$USER->GetGroups();
		$result = unserialize($redis->get($key));
		if($result!==false){
			$this->arResult = $redis->get($key);
		}
		else{
			$rArr = Application::getInstance()->getContext()->getRequest();
			if(isset($this->arParams['price'])){
				$list = $this->select($this->arParams,$rArr);		
				$user = $this->user();
				$this->arResult = ['list'=>$list,'user'=>$user,'url'=>$rArr->getRequestUri()];				
				
			} 
			else{
				$this->arResult = false;
			}	
			$redis->set($key,$this->arResult);	
		}
		if(isset($this->arParams['INSERT_LOG'])){
			$this->arr($this->arParams);
			$this->arr($this->arResult);
		}
		$this->InitComponentTemplate();
		$template = $this->GetTemplate();
		if (@$_SERVER['HTTP_X_REQUESTED_WITH'] != 'XMLHttpRequest') {
			componentCss(__DIR__,$template);
			componentJs(__DIR__,$template);
		}
		$this->IncludeComponentTemplate(); 		
    }
}