document.addEventListener("DOMContentLoaded", () => {
       const blogSlider = new Swiper('.blog-slider', {
           observeParents: true,
           observer: true,
           observeSlideChildren: true,
           slidesPerView: 'auto',
           spaceBetween: 20,
           cssMode: false,
           pagination: {
               clickable: true,
               el: '.blog-pagination'
           },
           slideToClickedSlide: true,
           breakpoints: {
               1680: {
                   slidesPerView: 4,
                   slidesPerGroup: 4,
               }
           }
       });
});

$(document).on('click','.filternews',function () {
    $(this).siblings().removeClass('active');
    $(this).addClass('active');
    var filter = $(this).attr('filter');
    $.ajax({
        type: "POST",
        url: "/ajax/component.php",
        async: false,
        data:{name:'ajaxblog',filter:filter},
        success: function(data){
            data = data.toString();
            if(data.includes('blog-card swiper-slide')){
                $('.blog-slider .swiper-wrapper').html(data);
            }
        }
    });
});