<?
use Bitrix\Main;
use Bitrix\Main\Localization\Loc;
use Bitrix\Main\Type;
use Bitrix\Iblock\ElementTable;
use Bitrix\Iblock\Iblock;
use Bitrix\Sale\Internals;
use Bitrix\Main\Application;
use Bitrix\Main\Loader;

class IblockList{
	public $dquery;
	public static $codes;
	public $arrxml;
	public function __construct($id,$arrxml){
		$this->dquery=$id;
		$this->arrxml = $arrxml;
		return $this;
	}
	public function prop($ids){	
		$props = [];	
		foreach($this->dquery as $value){
			$props[]=$value['ID'];
			self::$codes[$value['ID']] = $value['CODE'];
		}
		if(is_array($ids)){
			$ids = implode("','",$ids);
		}
		if(is_array($props)){
			$props = implode("','",$props);
		}
		$this->dquery="SELECT `VALUE`,`IBLOCK_ELEMENT_ID`,`IBLOCK_PROPERTY_ID`,`VALUE_ENUM` FROM `b_iblock_element_property` WHERE `IBLOCK_PROPERTY_ID` IN ('$props') AND `IBLOCK_ELEMENT_ID` IN ('$ids')";
		return $this;
	}
	public function quotes($return)
    {
        $return = preg_replace('#([^0-9_a-z,A-Zа-я.А-Я-]+)#', '', $return);
        return $return;
    }
	public function list($arr){		
		$props = implode("','",$arr);		
		$id = $this->dquery;
		$this->dquery="SELECT `ID`,`CODE` FROM `b_iblock_property` WHERE `IBLOCK_ID`=$id AND `ACTIVE`='Y' AND `CODE` IN ('$props')";
		return $this;
	}
	public function echo(){
		$echo=$this->dquery;
		$this->dquery = '';
		return $echo;
	}
	public function pre($arr){
		echo '<pre>';
		print_r($arr);
		echo '</pre>';
	}
	public function pquery($id,$value){
		$query = "SELECT `VALUE`,`XML_ID` FROM `b_iblock_property_enum` WHERE `PROPERTY_ID`=$id AND `ID`='$value'";
		$return=Application::getConnection()->query($query)->fetchAll();
		return $return;
	}
	public function query(){
		$this->dquery=Application::getConnection()->query($this->dquery);
		return $this;
	}
	public function one(){
		$this->dquery = $this->dquery->fetch();
		return $this;
	}
	public function all(){
		$this->dquery = $this->dquery->fetchAll();
		return $this;
	}
	public function props(){
		foreach($this->dquery as $key=>$item){			
			$arr_pquery = $this->pquery($item['IBLOCK_PROPERTY_ID'],$item['VALUE']);
			if((int)$item['VALUE_ENUM']!=0){
				if($this->arrxml && isset($this->arrxml[self::$codes[$item['IBLOCK_PROPERTY_ID']]])){
					$this->dquery[$key]['VALUE'] = $arr_pquery[0]['XML_ID'];
				}
				else{	
					$this->dquery[$key]['VALUE'] = $arr_pquery[0]['VALUE'];										
				}				
			}
		}
		return $this;
	}
	public function return(){
		$arr = ['code'=>self::$codes,'res'=>$this->dquery];
		return $arr;
	}
}
class getlistClass extends CBitrixComponent{
	public function arr($arr){
		echo '<pre>';
		print_r($arr);
		echo '</pre>';
	}
	private function load($params,$params2,$iblockobj=null){
		$result = [];
		if($iblockobj==null){
			$dbItems = ElementTable::getList($params);
		}
		else{
			$dbItems = $iblockobj->getEntityDataClass()::getList($params);
		}
		if(isset($params2['IS_COUNT']) && $params2['IS_COUNT']===true){
			$result['count'] = $dbItems->getCount(); 
			$result['count_page'] = $dbItems->getSelectedRowsCount(); 
		}
		$result['return'] = $dbItems->fetchAll();
		if(isset($params2['PROPERTY'])){
			foreach($result['return'] as $key=>$item){
				$ids[] = $item['ID'];
			}
			if(isset($params2['XML'])){
				$arrxml = $params2['XML'];
			}
			else{
				$arrxml = false;
			}
			$obj = new IblockList($params2['FILTER']['IBLOCK_ID'],$arrxml);
			$property = $obj->list($params2['PROPERTY'])->query()->all()->prop($ids)->query()->all()->props()->return();			
			foreach($result['return'] as $key=>$item){
				foreach($property['res'] as $prop){
					$i=0;
					if($prop['IBLOCK_ELEMENT_ID']==$item['ID']){
						if(isset($result['return'][$key]['PROP_'.$property['code'][$prop['IBLOCK_PROPERTY_ID']]])){
							$i++;
							$result['return'][$key]['PROP_'.$property['code'][$prop['IBLOCK_PROPERTY_ID']].'_'.$i] = $prop['VALUE'];
						}
						else{
							$result['return'][$key]['PROP_'.$property['code'][$prop['IBLOCK_PROPERTY_ID']]] = $prop['VALUE'];
						}
						
					}
				}
			}
		}
		return $result;
	}
    public function select($param=null,$arrList2=null){
		Loader::includeModule('iblock');
		$arrList = [];
		if($param==null){
			$param = $this->arParams;			
			$arrList2 = $this->arParams;
		}
		if(isset($param['ORDER'])){
			$arrList['order'] = $param['ORDER'];
		}
		else{
			$arrList['order'] = ['SORT' => 'ASC'];
		}
		if(isset($param['FIELDS'])){
			$arrList['select'] = $param['FIELDS'];
		}
		else{
			$arrList['select'] = ['ID','NAME'];
		}
		if(isset($param['FILTER'])){
			$arrList['filter'] = $param['FILTER'];
		}
		if(isset($param['LIMIT'])){
			$arrList['limit'] = (int)$param['LIMIT'];
		}
		else{
			$arrList['limit'] = 1000;
		}		
		if(isset($param['OFFSET'])){
			$arrList['offset'] = (int)$param['OFFSET'];
		}
		else{
			$arrList['offset'] = 0;
		}
		if(isset($param['CACHE']) && $param['CACHE']===true){
			$arrList['cache'] = ['ttl' => 3600,'cache_joins' => true];			
		}
		if(isset($param['IS_COUNT']) && $param['IS_COUNT']===true){
			$arrList['count_total'] = 1;			
		}
		if(isset($arrList2['object'])){
			$result = $this->load($arrList,$arrList2,$arrList2['object']);
		}
		else{
			$result = $this->load($arrList,$arrList2);
		}
		return $result;
	}
	public function preload($arr,$iblock=null){
		if(isset($arr['sort'])){
			$arr1['ORDER']=$arr['sort'];
		}
		if(isset($arr['property'])){
			$arr2['PROPERTY']=$arr['property'];	
		}
		if(isset($arr['fields'])){
			$arr1['FIELDS']=$arr['fields'];
			$arr2['FIELDS']=$arr['fields'];
		}
		if(isset($arr['filter'])){
			$arr1['FILTER']=$arr['filter'];	
			$arr2['FILTER']=$arr['filter'];
		}
		if(isset($arr['limit'])){
			$arr1['LIMIT']=$arr['limit'];
			$arr2['LIMIT']=$arr['limit'];
		}	
		if(isset($arr['offset'])){
			$arr1['OFFSET']=$arr['offset'];
			$arr2['OFFSET']=$arr['offset'];
		}
		if($iblock!=null){
			CModule::IncludeModule("iblock");
			$iblockobj = \Bitrix\Iblock\Iblock::wakeUp($iblock);
			$arr2['object'] = $iblockobj;			
		}
		return $this->select($arr1,$arr2);
	}
    public function executeComponent(){
		global $USER;
        $this->includeComponentLang('lang.php');
		if(isset($this->arParams['debag'])){	
            echo 'hello'.date("H:i:s");
        }      
		if(isset($this->arParams['FILTER']['IBLOCK_ID'])){
			$redis = new Redis();
			$redis->connect('127.0.0.1', 6379);
			$redis->setOption(Redis::OPT_SCAN, Redis::SCAN_RETRY);
			$key =  md5(serialize($this->arParams)).'--iblock-'.$this->arParams['FILTER']['IBLOCK_ID'].'--'.$USER->GetGroups();
			$result = unserialize($redis->get($key));
			if($result!==false){
				$this->arResult = $redis->get($key);
			}
			else{
				$this->arResult = $this->select();
				$redis->set($key,$this->arResult);  
			}  
		}
		else{
			$this->arResult = false;
		}
        if(isset($this->arParams['INSERT_LOG'])){
			$this->arr($this->arParams);
			$this->arr($this->arResult);
		}
		$this->InitComponentTemplate();
		$template = $this->GetTemplate();
		if (@$_SERVER['HTTP_X_REQUESTED_WITH'] != 'XMLHttpRequest') {
			componentCss(__DIR__,$template);
			componentJs(__DIR__,$template);
		}
        $this->IncludeComponentTemplate(); 
    }
}